/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.utils;

import filenet.vw.api.VWException;
import filenet.vw.base.StringUtils;
import filenet.vw.base.VWVersion;
import filenet.vw.base.logging.Level;
import filenet.vw.base.logging.Logger;
import filenet.ws.utils.WSConstants;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;

public class P8BPMSoapActionURI {
    private static final int NREQUIRED = 9;
    protected static Logger logger = Logger.getLogger("filenet.ws.utils.soapaction");
    protected static final String m_className = "P8PBMSoapActionURI";
    private String m_soapActionURI = null;
    private VWVersion vwVersion = null;
    private String m_portType = null;
    private String m_op = null;
    private String m_workClassName = "0";
    private String m_mapId = "0";
    private String m_onlineId = "0";
    private String m_workClassRevision = "0";
    private String m_wsLibraryId = "0";
    private String m_wsFolderId = "0";
    private int m_wsdlVersion = WSConstants.getDefaultWSDLVersion();
    private ArrayList m_ext = new ArrayList();
    private ArrayList m_reply = null;
    private ArrayList m_sync = null;
    private ArrayList m_rm = null;
    private static final String SYNC = "sync";
    private static final String RM = "rm";
    private static final String REPLY = "reply";
    private static String HOSTNAME = "localhost";
    private static long counter;
    private static Object syncObj;

    private int getWSDLVersionFromString(String s) {
        if (s == null || s.length() == 0) {
            return -1;
        }
        if (s.indexOf(WSConstants.getWSConstants((int)0).P8BPM_NS_PREFIX) != -1) {
            return 0;
        }
        if (s.indexOf(WSConstants.getWSConstants((int)10).P8BPM_NS_PREFIX) != -1) {
            return 10;
        }
        if (s.indexOf(WSConstants.getWSConstants((int)20).P8BPM_NS_PREFIX) != -1) {
            return 20;
        }
        if (s.indexOf(WSConstants.getWSConstants((int)30).P8BPM_NS_PREFIX) != -1) {
            return 30;
        }
        return -1;
    }

    private void parse() throws VWException {
        String m_method = "parse";
        if (logger.isFinest()) {
            logger.finest(m_className, "parse", this.m_soapActionURI);
        }
        this.m_wsdlVersion = -1;
        this.m_wsdlVersion = this.getWSDLVersionFromString(this.m_soapActionURI);
        if (this.m_wsdlVersion == -1) {
            throw new VWException("filenet.ws.utils.P8BPMSoapAction.invalidSOAPActionURI", "Invalid SOAP Action URI.");
        }
        this.m_soapActionURI = WSConstants.UTF8Decode(this.m_soapActionURI);
        String s = this.m_soapActionURI.substring(WSConstants.getWSConstants((int)this.m_wsdlVersion).P8BPM_NS_PREFIX.length());
        String[] res = StringUtils.split(s, "!");
        if (res != null && logger.isLoggable(Level.FINEST) && logger.isFinest()) {
            logger.finest(m_className, "parse", "res=" + Logger.asString(res));
        }
        if (res == null || res.length < 9) {
            throw new VWException("filenet.ws.utils.P8BPMSoapAction.invalidSOAPActionURI", "Invalid SOAP Action URI.");
        }
        String ss = WSConstants.UTF8Decode(res[0]);
        try {
            this.vwVersion = new VWVersion(ss);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.m_workClassName = WSConstants.UTF8Decode(res[1]);
        this.m_portType = res[2];
        this.m_op = res[3];
        this.m_mapId = res[4];
        this.m_onlineId = res[5];
        this.m_workClassRevision = res[6];
        this.m_wsLibraryId = WSConstants.UTF8Decode(res[7]);
        this.m_wsFolderId = WSConstants.UTF8Decode(res[8]);
        int nExts = res.length - 9;
        ArrayList list = this.m_ext;
        if (nExts > 0) {
            for (int i = 0; i < nExts; ++i) {
                if (res[9 + i] == null) continue;
                if (res[9 + i].equals(REPLY)) {
                    this.m_reply = new ArrayList();
                    list = this.m_reply;
                    continue;
                }
                if (res[9 + i].equals(SYNC)) {
                    this.m_sync = new ArrayList();
                    list = this.m_sync;
                    continue;
                }
                if (res[9 + i].equals(RM)) {
                    this.m_rm = new ArrayList();
                    list = this.m_rm;
                    continue;
                }
                list.add(res[9 + i]);
            }
        }
    }

    public P8BPMSoapActionURI(String s) throws VWException {
        String m_method = "ctor";
        if (s.startsWith("\"")) {
            s = s.substring(1);
        }
        if (s.endsWith("\"")) {
            s = s.substring(0, s.length() - 1);
        }
        this.m_soapActionURI = s;
        this.parse();
    }

    public VWVersion getVWVersion() {
        return this.vwVersion;
    }

    public String getWorkClassName() {
        return this.m_workClassName;
    }

    public String getPortType() {
        return this.m_portType;
    }

    public String getOperation() {
        return this.m_op;
    }

    public String getMapId() {
        return this.m_mapId;
    }

    public String getOnlineId() {
        return this.m_onlineId;
    }

    public String getWorkClassRevision() {
        return this.m_workClassRevision;
    }

    public String getWsLibraryId() {
        return this.m_wsLibraryId;
    }

    public String getWsFolderId() {
        return this.m_wsFolderId;
    }

    public int getWSDLVersion() {
        return this.m_wsdlVersion;
    }

    public String getExtensibleItemsAsString() {
        StringBuffer buf = new StringBuffer();
        Iterator it = null;
        if (this.m_ext != null) {
            it = this.m_ext.iterator();
            while (it.hasNext()) {
                buf.append("!").append(it.next());
            }
        }
        if (this.m_reply != null) {
            it = this.m_reply.iterator();
            buf.append("!").append(REPLY);
            while (it.hasNext()) {
                buf.append("!").append(it.next());
            }
        }
        if (this.m_sync != null) {
            it = this.m_sync.iterator();
            buf.append("!").append(SYNC);
            while (it.hasNext()) {
                buf.append("!").append(it.next());
            }
        }
        if (this.m_rm != null) {
            it = this.m_rm.iterator();
            buf.append("!").append(RM);
            while (it.hasNext()) {
                buf.append("!").append(it.next());
            }
        }
        return buf.toString();
    }

    public P8BPMSoapActionURI() {
    }

    public void setVWVersion(String s) throws VWException {
        this.vwVersion = new VWVersion(s);
    }

    public void setVWVersion(VWVersion v) throws VWException {
        this.vwVersion = v;
    }

    public void setWorkClassName(String s) {
        if (s == null) {
            return;
        }
        this.m_workClassName = s;
    }

    public void setPortType(String s) {
        this.m_portType = s;
    }

    public void setOperation(String s) {
        this.m_op = s;
    }

    public void setMapId(String s) {
        if (s == null) {
            return;
        }
        this.m_mapId = s;
    }

    public void setOnlineId(String s) {
        if (s == null) {
            return;
        }
        this.m_onlineId = s;
    }

    public void addExtensibleItem(String s) {
        if (s == null) {
            return;
        }
        this.m_ext.add(s);
    }

    public void setWorkClassRevision(String s) {
        if (s == null) {
            return;
        }
        this.m_workClassRevision = s;
    }

    public void setWsLibraryId(String s) {
        if (s == null) {
            return;
        }
        this.m_wsLibraryId = s;
    }

    public void setWSDLVersion(int version) {
        this.m_wsdlVersion = version;
    }

    public void setWsFolderId(String s) {
        if (s == null) {
            return;
        }
        this.m_wsFolderId = s;
    }

    public String toStringEx() throws VWException {
        if (this.vwVersion == null || this.m_portType == null || this.m_op == null) {
            throw new VWException("filenet.ws.utils.P8BPMSoapAction.invalidSOAPActionURI", "Invalid SOAP Action URI.");
        }
        StringBuffer m_desc = new StringBuffer();
        m_desc.append(WSConstants.getWSConstants((int)this.m_wsdlVersion).P8BPM_NS_PREFIX);
        m_desc.append(WSConstants.UTF8Encode(this.vwVersion.toString()));
        m_desc.append("!").append(WSConstants.UTF8Encode(this.m_workClassName));
        m_desc.append("!").append(this.m_portType);
        m_desc.append("!").append(this.m_op);
        m_desc.append("!").append(this.m_mapId);
        m_desc.append("!").append(this.m_onlineId);
        m_desc.append("!").append(this.m_workClassRevision);
        m_desc.append("!").append(WSConstants.UTF8Encode(this.m_wsLibraryId));
        m_desc.append("!").append(WSConstants.UTF8Encode(this.m_wsFolderId));
        m_desc.append(this.getExtensibleItemsAsString());
        String s = m_desc.toString();
        if (logger.isFinest()) {
            logger.finest(m_className, "toStringEx", s);
        }
        return s;
    }

    public boolean isReply() {
        return this.m_reply != null && this.m_reply.size() >= 1;
    }

    public String getReplyWobNum() {
        if (!this.isReply()) {
            return null;
        }
        return (String)this.m_reply.get(0);
    }

    public int getReplyRegionNumber() {
        if (!this.isReply() || this.m_reply.size() < 2) {
            return -1;
        }
        String s = (String)this.m_reply.get(1);
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public void setReply(String wobNum, int regionNumber) {
        if (this.m_reply == null) {
            this.m_reply = new ArrayList();
        } else {
            this.m_reply.clear();
        }
        this.m_reply.add(wobNum);
        this.m_reply.add(Integer.toString(regionNumber));
    }

    public boolean isSync() {
        return this.m_sync != null && this.m_sync.size() >= 2;
    }

    public String getSyncServerName() {
        if (!this.isSync()) {
            return null;
        }
        return (String)this.m_sync.get(0);
    }

    public long getSyncTimestamp() {
        if (!this.isSync()) {
            return -1L;
        }
        try {
            return Long.parseLong((String)this.m_sync.get(1));
        }
        catch (Exception e) {
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSync() {
        if (this.m_sync == null) {
            this.m_sync = new ArrayList();
        } else {
            this.m_sync.clear();
        }
        try {
            this.m_sync.add(HOSTNAME);
        }
        catch (Exception e) {
            this.m_sync.add("localhost");
        }
        this.m_sync.add(Long.toString(new Date().getTime()));
        Object object = syncObj;
        synchronized (object) {
            this.m_sync.add(Long.toString(++counter));
        }
    }

    public boolean isRM() {
        return this.m_rm != null && this.m_rm.size() >= 1;
    }

    public String getRMWobNum() {
        if (this.isRM()) {
            return (String)this.m_rm.get(0);
        }
        return null;
    }

    public void setRM(String wobNum) {
        if (wobNum == null) {
            if (this.m_rm != null) {
                this.m_rm.clear();
                this.m_rm = null;
            }
        } else {
            if (this.m_rm == null) {
                this.m_rm = new ArrayList();
            } else {
                this.m_rm.clear();
            }
            if (wobNum != null) {
                this.m_rm.add(wobNum);
            }
        }
    }

    public static void main(String[] args) {
        try {
            String s = "~~1\tabc\t3\t5\t7\t0";
            VWVersion v = new VWVersion(s);
            P8BPMSoapActionURI test = new P8BPMSoapActionURI();
            test.setVWVersion(v);
            test.setPortType("myPortType");
            test.setOperation("myOperation");
            String s2 = test.toStringEx();
            System.out.println("my soap action URI = " + s2);
            P8BPMSoapActionURI test2 = new P8BPMSoapActionURI(s2);
            P8BPMSoapActionURI soapActionURI = new P8BPMSoapActionURI("http://www.filenet.com/process/p8-3x/2004/%257E%257E1%2509VWService0%253Ahqepbpe2%253AFileNet%25091%2509169%25096%25091073458026000!ReceivePrototype!myPortTypePortType!myOp1!-2!-1!1!0!0");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("The end.");
        System.exit(0);
    }

    public static String _get_FILE_DATE() {
        return "$Date:   10 Sep 2008 10:04:28  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ysoong  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.22  $";
    }

    static {
        try {
            HOSTNAME = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        counter = 1L;
        syncObj = new Object();
    }
}

